<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'image');
    protected $visible = array('name_ar', 'name_en', 'image');

    public function persons()
    {
        return $this->hasMany('App\Models\TeamPerson', 'team_id');
    }

}